/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncTemperatureMessage {
    int entityId;
    CompoundTag traits;
    boolean instant;

    public SyncTemperatureMessage(LivingEntity entity, CompoundTag traits, boolean instant) {
        this.entityId = entity.m_19879_();
        this.traits = traits;
        this.instant = instant;
    }

    SyncTemperatureMessage(int entityId, CompoundTag traits, boolean instant) {
        this.entityId = entityId;
        this.traits = traits;
        this.instant = instant;
    }

    public static void encode(SyncTemperatureMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.m_130079_(message.traits);
        buffer.writeBoolean(message.instant);
    }

    public static SyncTemperatureMessage decode(FriendlyByteBuf buffer) {
        return new SyncTemperatureMessage(buffer.readInt(), buffer.m_130260_(), buffer.readBoolean());
    }

    public static void handle(SyncTemperatureMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                LivingEntity entity = (LivingEntity)Minecraft.m_91087_().f_91073_.m_6815_(message.entityId);
                if (entity != null) {
                    EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
                        cap.deserializeTraits(message.traits);
                        if (message.instant && cap instanceof PlayerTempCap) {
                            Overlays.setBodyTempInstant(cap.getTrait(Temperature.Trait.BODY));
                        }
                    });
                }
            });
        }
        context.setPacketHandled(true);
    }
}

